CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	IF EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'v_pdv_vd_rc_cli_conv') THEN 
		DROP VIEW v_pdv_vd_rc_cli_conv;
		RAISE NOTICE 'v_pdv_vd_rc_cli_conv Dropada.';
	END IF;
	
	CREATE OR REPLACE VIEW v_pdv_vd_rc_cli_conv AS 
	 SELECT rc_cli.cd_emp,
		rc_cli.cd_cli,
		rc_cli.rz_cli,
		rc_cli.nm_fant,
		rc_cli.cgc_cpf,
		rc_cli_conv.ds_conv,
		COALESCE(rc_cli.esp_cli, 0::numeric) AS esp_cli,
		COALESCE(rc_cli_conv_rc_cli.matricula, ''::character varying) AS matricula,
		rc_cli_conv_rc_cli.vlr_cred,
			CASE
				WHEN rc_cli_conv_rc_cli.sts_cred::numeric = 1::numeric THEN 'bloqueado'::text
				ELSE 'liberado'::text
			END AS sts_cred_conveniado,
			CASE 
				WHEN RC_CLI.STS_CRED = 0 THEN 
					CASE 
						WHEN RC_CLI_CONV.CONV_HABILITADO::numeric = 1::numeric THEN 'bloqueado'::text
						ELSE 'liberado'::text
					END
				ELSE 
					CASE 
						WHEN RC_CLI.STS_CRED::numeric = 1::numeric THEN 'bloqueado'::text
						ELSE 'liberado'::text
					END
			END AS sts_cred_convenio,
		COALESCE(rc_cli_conv_rc_cli.vlr_deb, 0.00)::double precision AS vlr_deb,
		COALESCE(rc_cli_conv_rc_cli.vlr_deb_futuro, 0.00)::double precision AS vlr_deb_futuro,
		rc_cli_conv.perc_desc,
		rc_cli_conv_rc_cli.cd_conv,
		rc_cli_conv_rc_cli.sts_ativo AS sts_cli,
		rc_cli_conv.tp_conv,
		rc_cli.cons_final,
		rc_cli_conv.instrucoes,
		COALESCE(rc_cli_conv.flag_requer_senha, 0::numeric) AS flag_requer_senha,
		COALESCE(rc_cli.senha, ''::character varying) AS senha,
		COALESCE(rc_cli.rot_conv_ext, 0::numeric) AS rot_conv_ext,
		COALESCE(rc_cli_conv.perc_rec_min_conv, 0::numeric) AS perc_rec_min_conv,
		COALESCE(rc_cli_conv.perc_rec_max_conv, 0::numeric) AS perc_rec_max_conv,
		COALESCE(rc_cli_conv_rc_cli.perc_rec_min_conv, 0::numeric::double precision) AS perc_rec_min_conveniado,
		COALESCE(rc_cli_conv_rc_cli.perc_rec_max_conv, 0::numeric::double precision) AS perc_rec_max_conveniado,
		COALESCE(rc_cli_conv.qt_max_parc, 0) AS qt_max_parc,
		COALESCE(rc_cli_conv.vlr_min_parc, 0::numeric) AS vlr_min_parc,
		COALESCE(rc_cli_conv.qtd_dias_prorrog::numeric, 0::numeric) AS qtd_dias_prorrog,
		COALESCE(rc_cli_conv.dia_fat, 0::numeric) AS dia_fat
	   FROM rc_cli
		 LEFT JOIN rc_cli_conv_rc_cli ON rc_cli.cd_cli = rc_cli_conv_rc_cli.cd_cli::numeric AND rc_cli.cd_emp = rc_cli_conv_rc_cli.cd_emp::numeric
		 LEFT JOIN rc_cli_conv ON rc_cli_conv_rc_cli.cd_conv = rc_cli_conv.cd_conv AND rc_cli.cd_emp = rc_cli_conv.cd_emp
	  WHERE rc_cli.sts_cli = 0::numeric;

	ALTER TABLE v_pdv_vd_rc_cli_conv
	  OWNER TO postgres;
		
	RAISE NOTICE 'v_pdv_vd_rc_cli_conv Recriada.';

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();